/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.comp.LogoJPopupMenu;
import DE.siemens.ad.logo.dialog.SimulationOptionsPanel;
import DE.siemens.ad.logo.dialog.comp.MessageDisplay;
import DE.siemens.ad.logo.dialog.comp.MessageReceiptListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.TickerDisplayModel;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.ParameterUpdateEvent;
import DE.siemens.ad.logo.model.ParameterUpdateListener;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.action.EditBlockPropertiesAction;
import DE.siemens.ad.pdraw.action.GotoBlockAction;
import DE.siemens.ad.pdraw.simulation.OnlineTestInterpreter;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MessageWindow
extends JDialog
implements MessageReceiptListener,
ParameterSetListener {
    private JPanel fBMPanel;
    private JPanel fTDPanel;
    private CharsetSelectionPanel fBMCharsetPanel;
    private CharsetSelectionPanel fTDCharsetPanel;
    private SingleMessagePanel[] fMessagePanels;
    protected MessageManager fMessageManager;
    private int fBMCharsetID = 0;
    private int fTDCharsetID = 0;
    private boolean fUpdateVisibilityFlag = false;
    private boolean fIsClosed;
    private boolean fShowErrorInfo = true;
    public static transient long fLastPaintTime = 0L;
    private boolean fIsOnlineTest;
    private boolean fEditActive = false;
    private Editor fEditor;

    private MessageWindow(JFrame parent) {
        super(parent);
    }

    private MessageWindow(JDialog parent) {
        super(parent);
    }

    public static MessageWindow createMessageWindow(Editor editor, MessageManager msgManager, boolean isOnlineTest) {
        MessageWindow messageWindow = null;
        Window parentWindow = editor.getApplicationSurface().getWindow();
        if (parentWindow instanceof JDialog) {
            messageWindow = new MessageWindow((JDialog)parentWindow);
        } else if (parentWindow instanceof JFrame) {
            messageWindow = new MessageWindow((JFrame)parentWindow);
        } else {
            throw new IllegalArgumentException("Parent of a MessageWindow must be a JDialog or JFrame.");
        }
        messageWindow.fEditor = editor;
        messageWindow.fIsOnlineTest = isOnlineTest;
        messageWindow.initialize(editor, msgManager);
        return messageWindow;
    }

    private void initialize(Editor editor, MessageManager msgManager) {
        this.fMessageManager = msgManager;
        this.setName("MessageWindow");
        this.setDefaultCloseOperation(2);
        this.setFont(new Font("dialog", 0, 8));
        this.setTitle(Language.getString("block.Message", "Message"));
        this.setResizable(false);
        if (this.fMessageManager.isRTFMessage()) {
            this.setContentPane(new JPanel(new GridBagLayout()));
            this.fBMPanel = new JPanel(new CardLayout());
            this.fTDPanel = new JPanel(new CardLayout());
            this.fMessagePanels = new SingleMessagePanel[4];
            this.fMessagePanels[0] = new SingleMessagePanel(this, editor, 0, false);
            this.fBMPanel.add((Component)this.fMessagePanels[0], "0");
            this.fMessagePanels[1] = new SingleMessagePanel(this, editor, 1, false);
            this.fBMPanel.add((Component)this.fMessagePanels[1], "1");
            this.fMessagePanels[2] = new SingleMessagePanel(this, editor, 0, true);
            this.fTDPanel.add((Component)this.fMessagePanels[2], "0");
            this.fMessagePanels[3] = new SingleMessagePanel(this, editor, 1, true);
            this.fTDPanel.add((Component)this.fMessagePanels[3], "1");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.anchor = 17;
            this.getContentPane().add((Component)this.fBMPanel, gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 13;
            this.getContentPane().add((Component)this.fTDPanel, gbc);
            this.fBMCharsetPanel = new CharsetSelectionPanel(this.fMessageManager.getWiringDiagram().getMessageGlobalInfo().getCurCharSetID());
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            this.fBMCharsetPanel.setEnabled(!this.fIsOnlineTest);
            this.getContentPane().add((Component)this.fBMCharsetPanel, gbc);
            this.fTDCharsetPanel = new CharsetSelectionPanel(this.fMessageManager.getWiringDiagram().getMessageGlobalInfo().getCurCharSetID());
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.anchor = 13;
            this.fTDCharsetPanel.setEnabled(!this.fIsOnlineTest);
            this.getContentPane().add((Component)this.fTDCharsetPanel, gbc);
            this.fBMCharsetPanel.setVisible(this.fMessageManager.getSpecialMarkerValue(27) == -1);
            this.fTDCharsetPanel.setVisible(this.fMessageManager.getSpecialMarkerValue(27) == -1);
        } else {
            this.fBMPanel = new JPanel(new CardLayout());
            this.fMessagePanels = new SingleMessagePanel[2];
            this.fMessagePanels[0] = new SingleMessagePanel(this, editor, 0, false);
            this.fBMPanel.add((Component)this.fMessagePanels[0], "0");
            this.fMessagePanels[1] = new SingleMessagePanel(this, editor, 1, false);
            this.fBMPanel.add((Component)this.fMessagePanels[1], "1");
            this.setContentPane(this.fBMPanel);
        }
    }

    public MessageManager getMessageManager() {
        return this.fMessageManager;
    }

    private boolean isTDPanelShown() {
        if (this.fIsOnlineTest) {
            return false;
        }
        return LogoProperties.instance().getBooleanProperty(SimulationOptionsPanel.SIMULATION_TD_MSG, true);
    }

    public void interpreterCycleFinished() {
        if (this.fIsOnlineTest) {
            if (OnlineTestTool.isMsgOnlineTestEnabled() && this.fEditor.isActivated()) {
                int msgNumber = OnlineTestInterpreter.fMessageDataCenter.getCurrentMsgNumber();
                if (OnlineTestInterpreter.fMessageDataCenter.isNoMsgDisplayOnBM()) {
                    if (this.fShowErrorInfo) {
                        Log.println(Language.getString("dialog.error.noMessageOnBM", "No message displayed on BM."));
                    }
                    this.fShowErrorInfo = false;
                } else {
                    this.fShowErrorInfo = true;
                }
                this.fMessagePanels[this.fBMCharsetID].setActivaMessageNumber(msgNumber);
                MessageDisplay msgDisp = this.fMessagePanels[this.fBMCharsetID].getMessageDisplay(null);
                if (msgDisp != null && msgDisp.getLogoDisplay().getModel() instanceof TickerDisplayModel) {
                    ((TickerDisplayModel)msgDisp.getLogoDisplay().getModel()).setTickerOffset(OnlineTestInterpreter.fMessageDataCenter.getLineOffsets());
                }
                this.notifyVisibilityUpdates();
            } else {
                this.setVisible(false);
            }
        }
        this.updateVisibility();
        if (!this.isVisible()) {
            return;
        }
        this.setActiveCharset();
        if (System.currentTimeMillis() - fLastPaintTime > this.getPaintDelay()) {
            for (int i = 0; i < this.fMessagePanels.length; ++i) {
                if (!this.fMessagePanels[i].isVisible()) continue;
                this.fMessagePanels[i].repaint();
            }
            fLastPaintTime = System.currentTimeMillis();
        }
    }

    private long getPaintDelay() {
        if (System.getProperty("java.vm.version").startsWith("1.5")) {
            return 200L;
        }
        return 50L;
    }

    private void notifyVisibilityUpdates() {
        this.fUpdateVisibilityFlag = true;
    }

    private void updateVisibility() {
        if (this.fUpdateVisibilityFlag) {
            this.fUpdateVisibilityFlag = false;
            boolean visible = false;
            for (int i = 0; i < this.fMessagePanels.length; ++i) {
                if (this.fMessagePanels[i].getActivePanelIndex() == -1) continue;
                visible = true;
                break;
            }
            if ((visible && this.fEditActive) != this.isVisible()) {
                this.setVisible(visible && this.fEditActive);
            }
        }
    }

    public void setCloseStatus(boolean status) {
        this.fIsClosed = status;
    }

    private void setActiveCharset() {
        int markerCharsetID = this.fMessageManager.getSpecialMarkerValue(27);
        if (markerCharsetID != -1 && this.fBMCharsetPanel == null && markerCharsetID != this.fBMCharsetID) {
            this.fBMCharsetID = 1 - this.fBMCharsetID;
            this.layoutForCharsetBM();
            return;
        }
        if (markerCharsetID != -1 && markerCharsetID != this.fBMCharsetID || markerCharsetID == -1 && this.fBMCharsetPanel != null && this.fBMCharsetPanel.getCharsetSelection() != this.fBMCharsetID) {
            this.fBMCharsetID = 1 - this.fBMCharsetID;
            this.layoutForCharsetBM();
        }
        if (this.getMessageManager().isRTFMessage() && (markerCharsetID != -1 && markerCharsetID != this.fTDCharsetID || markerCharsetID == -1 && this.fTDCharsetPanel.getCharsetSelection() != this.fTDCharsetID)) {
            this.fTDCharsetID = 1 - this.fTDCharsetID;
            this.layoutForCharsetTD();
        }
    }

    private void layoutForCharsetBM() {
        if (this.fBMCharsetID == 0) {
            ((CardLayout)this.fBMPanel.getLayout()).first(this.fBMPanel);
        } else {
            ((CardLayout)this.fBMPanel.getLayout()).last(this.fBMPanel);
        }
    }

    private void layoutForCharsetTD() {
        if (this.fTDCharsetID == 0) {
            ((CardLayout)this.fTDPanel.getLayout()).first(this.fTDPanel);
        } else {
            ((CardLayout)this.fTDPanel.getLayout()).last(this.fTDPanel);
        }
    }

    public void startSimulation() {
        int i;
        MessageBlock[] blocks = this.fMessageManager.getMessageBlocks();
        for (i = 0; i < blocks.length; ++i) {
            ((BinaryOutBlockConnector)blocks[i].getOutConnector(0)).setBinaryValue(false);
        }
        this.setAsParameterSetListener();
        for (i = 0; i < this.fMessagePanels.length; ++i) {
            this.fMessagePanels[i].startSimulation();
        }
        this.fEditActive = true;
    }

    public void endSimulation() {
        this.setVisible(false);
        this.removeAsParameterSetListener();
        for (int i = 0; i < this.fMessagePanels.length; ++i) {
            this.fMessagePanels[i].endSimulation();
        }
        this.fMessageManager.clearRTFModels();
    }

    private void setAsParameterSetListener() {
        MessageBlock[] blocks = this.getMessageManager().getMessageBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            MessageParameter msgParam = (MessageParameter)blocks[i].getParameter();
            msgParam.addParameterSetListener(this);
        }
    }

    private void removeAsParameterSetListener() {
        MessageBlock[] blocks = this.getMessageManager().getMessageBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            MessageParameter msgParam = (MessageParameter)blocks[i].getParameter();
            msgParam.removeParameterSetListener(this);
        }
    }

    public void setVisible(boolean visibility) {
        if (visibility) {
            if (this.fTDPanel != null) {
                this.fTDPanel.setVisible(this.isTDPanelShown());
            }
            if (this.fTDCharsetPanel != null) {
                this.fTDCharsetPanel.setVisible(this.isTDPanelShown());
            }
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screenSize.width - this.getWidth() - 20, screenSize.height - this.getHeight() - 60);
        }
        super.setVisible(visibility);
    }

    public void setEditorActivated(boolean editorActivated) {
        this.fEditActive = editorActivated;
        if (!this.fIsClosed) {
            this.notifyVisibilityUpdates();
        }
    }

    public void messageReceipt(MessageDisplay messageDisplay) {
        MessageParameter msgParamter = messageDisplay.getMessageParameter();
        for (int i = 0; i < this.fMessagePanels.length; ++i) {
            this.fMessagePanels[i].disableMessageDisplay(msgParamter);
        }
        this.notifyVisibilityUpdates();
        this.updateVisibility();
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        boolean isVisible = this.isVisible();
        if (isVisible) {
            this.setVisible(false);
        }
        if (parameter instanceof MessageParameter) {
            for (int i = 0; i < this.fMessagePanels.length; ++i) {
                this.fMessagePanels[i].updateAll();
            }
        }
        if (isVisible) {
            this.setVisible(true);
        }
    }

    private class CharsetSelectionPanel
    extends JPanel {
        private JRadioButton[] fCharsets = null;

        public CharsetSelectionPanel(int defaultCharset) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = -1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.fCharsets = new JRadioButton[2];
            ButtonGroup bg1 = new ButtonGroup();
            for (int i = 0; i < this.fCharsets.length; ++i) {
                this.fCharsets[i] = new JRadioButton(Language.getString("dialog.parameter.message.charSetText", "Charset") + (i + 1));
                ++gbc.gridx;
                this.add((Component)this.fCharsets[i], gbc);
                bg1.add(this.fCharsets[i]);
                if (i != defaultCharset) continue;
                this.fCharsets[i].setSelected(true);
            }
        }

        public int getCharsetSelection() {
            if (this.fCharsets[1].isSelected()) {
                return 1;
            }
            return 0;
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.fCharsets[0].setEnabled(enabled);
            this.fCharsets[1].setEnabled(enabled);
        }
    }

    private class SingleMessagePanel
    extends JPanel
    implements ParameterUpdateListener,
    ChangeListener {
        private JTabbedPane ivjJTabbedPane = null;
        private MessageDisplay fMessageDisplay;
        private int fLinkedIndex = -1;
        private Block[] fRelatedBlocks;
        private JPanel[] fDeputyPanels;
        private JButton gotoMessageBlockButton;
        private Editor fEditor;
        private MessageWindowGotoBlockAction fGotoBlockAction;
        private MessageWindowEditBlockPropertiesAction fEditBlockPropertiesAction;
        private LogoJPopupMenu fPopupMenu;
        private JLabel fBlockNumberLabel;
        private MessageWindow fParent;
        private int fCharsetID;
        private JPanel fNoMsgPanel;
        private int fShowDestMask;

        public SingleMessagePanel(MessageWindow parent, Editor editor, int charsetID, boolean isForTextDisplay) {
            this.fEditor = editor;
            this.fParent = parent;
            this.fCharsetID = charsetID % 2;
            this.fShowDestMask = isForTextDisplay ? 2 : 1;
            this.initialize();
            this.setLayout(new BorderLayout());
        }

        public void endSimulation() {
            this.getJTabbedPane().removeChangeListener(this);
            this.disposeResource();
            this.fParent = null;
        }

        private void disposeResource() {
            if (this.fMessageDisplay != null) {
                this.fMessageDisplay.removeMessageReceiptListener(this.fParent);
                this.fMessageDisplay.removeMessageReceiptListener(this.fMessageDisplay.getMessageParameter());
                this.fMessageDisplay.deactivateUpdate();
                this.fMessageDisplay = null;
            }
            this.fLinkedIndex = -1;
            for (int i = 0; i < this.getRelatedBlocks().length; ++i) {
                ((MessageParameter)this.getRelatedBlocks()[i].getParameter()).removeParameterUpdateListener(this);
                this.getRelatedBlocks()[i] = null;
            }
            this.fRelatedBlocks = null;
            this.fDeputyPanels = null;
            this.getJTabbedPane().removeAll();
        }

        public void updateAll() {
            this.getJTabbedPane().removeChangeListener(this);
            this.disposeResource();
            this.getJTabbedPane().addChangeListener(this);
            this.fillTabbedPane();
        }

        private void fillTabbedPane() {
            int i;
            JTabbedPane tabPane = this.getJTabbedPane();
            tabPane.removeAll();
            for (i = 0; i < this.getRelatedBlocks().length; ++i) {
                tabPane.add(this.getDeputyPanels()[i]);
                tabPane.setToolTipTextAt(i, this.getRelatedBlocks()[i].getNumberString());
            }
            for (i = 0; i < this.getRelatedBlocks().length; ++i) {
                BinaryOutBlockConnector blockConnector = (BinaryOutBlockConnector)this.getRelatedBlocks()[i].getOutConnector(0);
                if (blockConnector.getBinaryValue()) {
                    tabPane.setForegroundAt(i, Global.SIMULATION_COLOR_HIGH);
                    this.getDeputyPanels()[i].setEnabled(true);
                    tabPane.setSelectedIndex(i);
                    continue;
                }
                tabPane.setForegroundAt(i, Color.gray);
                this.getDeputyPanels()[i].setEnabled(false);
            }
            if (this.getRelatedBlocks().length == 0) {
                this.getJTabbedPane().setVisible(false);
                this.getEmptyMsgPanel().setVisible(true);
                this.add((Component)this.getEmptyMsgPanel(), "Center");
            } else {
                this.getJTabbedPane().setVisible(true);
                this.getEmptyMsgPanel().setVisible(false);
                this.add((Component)this.getJTabbedPane(), "Center");
            }
        }

        protected int getActivePriority() {
            int activeIndex = this.getActivePanelIndex();
            if (activeIndex != -1) {
                return Integer.parseInt(this.getJTabbedPane().getTitleAt(activeIndex));
            }
            return -1;
        }

        protected JPanel getActiveTab() {
            int activeIndex = this.getActivePanelIndex();
            if (activeIndex != -1) {
                return (JPanel)this.getJTabbedPane().getComponentAt(activeIndex);
            }
            return null;
        }

        protected int getActivePanelIndex() {
            int retValue = -1;
            JTabbedPane tabPane = this.getJTabbedPane();
            int tabCount = tabPane.getTabCount();
            for (int i = tabCount - 1; i >= 0; --i) {
                if (!tabPane.getComponentAt(i).isEnabled()) continue;
                retValue = i;
                break;
            }
            return retValue;
        }

        private JTabbedPane getJTabbedPane() {
            if (this.ivjJTabbedPane == null) {
                this.ivjJTabbedPane = new JTabbedPane();
                this.ivjJTabbedPane.setName("JTabbedPane");
                this.ivjJTabbedPane.setEnabled(!MessageWindow.this.fIsOnlineTest);
            }
            return this.ivjJTabbedPane;
        }

        private JPanel getEmptyMsgPanel() {
            if (this.fNoMsgPanel == null) {
                this.fNoMsgPanel = new JPanel(new BorderLayout());
                JLabel title = new JLabel(this.getDestinationName());
                JLabel fNoMsgNotify = new JLabel(Language.getString("dialog.messageWindow.noMsgNofity", "No related Message text"));
                title.setHorizontalAlignment(0);
                fNoMsgNotify.setHorizontalAlignment(0);
                this.fNoMsgPanel.add((Component)title, "North");
                this.fNoMsgPanel.add(fNoMsgNotify);
            }
            return this.fNoMsgPanel;
        }

        protected int getSelectedPriority() {
            return Integer.parseInt(this.getJTabbedPane().getTitleAt(this.getJTabbedPane().getSelectedIndex()));
        }

        private void initialize() {
            this.fBlockNumberLabel = new JLabel("Blocknumber");
            this.fGotoBlockAction = new MessageWindowGotoBlockAction();
            this.fGotoBlockAction.setOwner(this.fEditor);
            this.fEditBlockPropertiesAction = new MessageWindowEditBlockPropertiesAction();
            this.fEditBlockPropertiesAction.setOwner(this.fEditor);
            this.fPopupMenu = new LogoJPopupMenu();
            this.fPopupMenu.add(this.fBlockNumberLabel);
            this.fPopupMenu.addSeparator();
            this.fPopupMenu.add(this.fGotoBlockAction);
            this.fPopupMenu.add(this.fEditBlockPropertiesAction);
        }

        private MessageDisplay getMessageDisplay(MessageParameter msgParam) {
            if (msgParam == null) {
                return this.fMessageDisplay;
            }
            if (this.fMessageDisplay == null) {
                this.fMessageDisplay = new MessageDisplay(MessageWindow.this.fIsOnlineTest);
                RightClickHandler rightClickHandler = new RightClickHandler();
                this.fMessageDisplay.getLogoDisplay().addMouseListener(rightClickHandler);
                this.fMessageDisplay.addMessageReceiptListener(this.fParent);
                this.gotoMessageBlockButton = new JButton(Global.getIcon("Goto.gif"));
                GotoMessageBlockButtonHandler gotoMessageBlockButtonHandler = new GotoMessageBlockButtonHandler();
                this.gotoMessageBlockButton.addActionListener(gotoMessageBlockButtonHandler);
                this.fMessageDisplay.getButtonPanel().add(this.gotoMessageBlockButton);
                this.fMessageDisplay.activateDeactivateEditButton();
                this.fMessageDisplay.setTitle(this.getDestinationName());
            }
            if (this.fMessageDisplay.getMessageParameter() == msgParam) {
                return this.fMessageDisplay;
            }
            this.fMessageDisplay.setName(msgParam.getPriority().toString());
            this.fMessageDisplay.removeMessageReceiptListener(this.fMessageDisplay.getMessageParameter());
            this.fMessageDisplay.setMessageParameter(msgParam, this.fCharsetID);
            this.fMessageDisplay.addMessageReceiptListener(msgParam);
            this.fMessageDisplay.activateDeactivateEditButton();
            this.gotoMessageBlockButton.setToolTipText(Language.getString("dialog.messageWindow.gotoMessageBlock.tooltip", "Goto message block %.", new Object[]{msgParam.getBlock().getNumberString()}));
            return this.fMessageDisplay;
        }

        private String getDestinationName() {
            if (this.fShowDestMask == 2) {
                return Language.getString("dialog.parameter.message.showDest1", "TD");
            }
            return Language.getString("dialog.parameter.message.showDest0", "BM");
        }

        private Block[] getRelatedBlocks() {
            if (this.fRelatedBlocks == null) {
                int i;
                TreeMap<Integer, MessageBlock> map = new TreeMap<Integer, MessageBlock>();
                MessageBlock[] blocks = this.fParent.getMessageManager().getMessageBlocks();
                if (this.fParent.getMessageManager().isRTFMessage()) {
                    for (i = 0; i < blocks.length; ++i) {
                        MessageParameter param = (MessageParameter)blocks[i].getParameter();
                        boolean dismiss = false;
                        if (param.getMessageRTF(this.fCharsetID) != null && (param.getMessageRTF(this.fCharsetID).getShowDest() & this.fShowDestMask) == 0) {
                            dismiss = true;
                        }
                        if (dismiss) continue;
                        map.put(((MessageParameter)blocks[i].getParameter()).getPriority(), blocks[i]);
                    }
                } else {
                    for (i = 0; i < blocks.length; ++i) {
                        map.put(((MessageParameter)blocks[i].getParameter()).getPriority(), blocks[i]);
                    }
                }
                Object[] tmpBlocks = map.values().toArray();
                this.fRelatedBlocks = new Block[tmpBlocks.length];
                for (int i2 = 0; i2 < this.fRelatedBlocks.length; ++i2) {
                    this.fRelatedBlocks[i2] = (Block)tmpBlocks[i2];
                    ((MessageParameter)this.fRelatedBlocks[i2].getParameter()).addParameterUpdateListener(this);
                }
            }
            return this.fRelatedBlocks;
        }

        private JPanel[] getDeputyPanels() {
            if (this.fDeputyPanels == null) {
                this.fDeputyPanels = new JPanel[this.getRelatedBlocks().length];
                for (int i = 0; i < this.fDeputyPanels.length; ++i) {
                    this.fDeputyPanels[i] = new JPanel();
                    this.fDeputyPanels[i].setEnabled(false);
                    this.fDeputyPanels[i].setName(((MessageParameter)this.getRelatedBlocks()[i].getParameter()).getPriority().toString());
                }
            }
            return this.fDeputyPanels;
        }

        private void disableMessageDisplay(MessageParameter msgParam) {
            JPanel tab;
            JTabbedPane tabPane = this.getJTabbedPane();
            int index = tabPane.indexOfComponent(tab = this.getTab(msgParam));
            if (index < 0) {
                return;
            }
            if (tab.isEnabled()) {
                tab.setEnabled(false);
                tabPane.setForegroundAt(index, new Color(50, 130, 200));
                if (tab == tabPane.getSelectedComponent()) {
                    this.updateTabbedPane();
                }
            }
        }

        private JPanel getTab(MessageParameter msgParam) {
            for (int i = 0; i < this.getRelatedBlocks().length; ++i) {
                if (this.getRelatedBlocks()[i].getParameter() != msgParam) continue;
                return (JPanel)this.getJTabbedPane().getComponentAt(i);
            }
            return null;
        }

        public void startSimulation() {
            this.getJTabbedPane().addChangeListener(this);
            this.fillTabbedPane();
        }

        public void updateTabbedPane() {
            JPanel nextTab = this.getActiveTab();
            if (nextTab != null) {
                this.getJTabbedPane().setSelectedComponent(nextTab);
                if (!nextTab.isEnabled()) {
                    nextTab.setEnabled(true);
                }
            }
        }

        public void parameterUpdated(final ParameterUpdateEvent parameterUpdateEvent) {
            if (!parameterUpdateEvent.getEventSource().equals("I0")) {
                return;
            }
            Runnable r = new Runnable(){

                public void run() {
                    if (SingleMessagePanel.this.fParent == null) {
                        return;
                    }
                    JTabbedPane tabPane = SingleMessagePanel.this.getJTabbedPane();
                    MessageParameter msgParam = (MessageParameter)parameterUpdateEvent.getParameter();
                    JPanel tab = SingleMessagePanel.this.getTab(msgParam);
                    if (tab == null) {
                        return;
                    }
                    int index = tabPane.indexOfComponent(tab);
                    int newPrio = msgParam.getPriority();
                    if (parameterUpdateEvent.getBinaryValue()) {
                        tabPane.setForegroundAt(index, Global.SIMULATION_COLOR_HIGH);
                        if (!tabPane.getComponentAt(index).isEnabled()) {
                            tabPane.getComponentAt(index).setEnabled(true);
                        }
                        if (newPrio == SingleMessagePanel.this.getActivePriority()) {
                            SingleMessagePanel.this.updateTabbedPane();
                        }
                    } else if (!msgParam.isReceipt()) {
                        SingleMessagePanel.this.disableMessageDisplay(msgParam);
                    }
                    SingleMessagePanel.this.fParent.notifyVisibilityUpdates();
                }
            };
            SwingUtilities.invokeLater(r);
        }

        public void setActivaMessageNumber(int messageNumber) {
            for (int i = 0; i < this.getRelatedBlocks().length; ++i) {
                if (messageNumber != ((MessageParameter)this.getRelatedBlocks()[i].getParameter()).getMsgNumber()) {
                    this.getJTabbedPane().getComponentAt(i).setEnabled(false);
                    this.getJTabbedPane().setForegroundAt(i, Global.SIMULATION_COLOR_LOW);
                    continue;
                }
                if (this.getJTabbedPane().getComponentAt(i).isEnabled()) continue;
                this.getJTabbedPane().getComponentAt(i).setEnabled(true);
                this.getJTabbedPane().setForegroundAt(i, Global.SIMULATION_COLOR_HIGH);
            }
            this.updateTabbedPane();
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = this.getJTabbedPane();
            if (!(tabPane.getSelectedComponent() instanceof MessageDisplay)) {
                if (this.fLinkedIndex != -1) {
                    if (!(tabPane.getComponentAt(this.fLinkedIndex) instanceof MessageDisplay)) {
                        System.err.println("Conflict status.");
                    }
                    this.getDeputyPanels()[this.fLinkedIndex].setEnabled(tabPane.getComponentAt(this.fLinkedIndex).isEnabled());
                    tabPane.setComponentAt(this.fLinkedIndex, this.getDeputyPanels()[this.fLinkedIndex]);
                }
                int index = tabPane.getSelectedIndex();
                MessageParameter msgParam = (MessageParameter)this.getRelatedBlocks()[index].getParameter();
                MessageDisplay msgDisplay = this.getMessageDisplay(msgParam);
                msgDisplay.setEnabled(this.getDeputyPanels()[index].isEnabled());
                tabPane.setComponentAt(index, msgDisplay);
                this.fLinkedIndex = index;
            }
        }

        public void repaint() {
            if (this.fMessageDisplay != null) {
                this.fMessageDisplay.updateReceiptStatus();
                this.fMessageDisplay.getLogoDisplay().setSimulationColor(this.getLogoDisplayColor());
            }
            super.repaint();
        }

        private Color getLogoDisplayColor() {
            int specialMarkerNumber = this.fShowDestMask == 1 ? 25 : 26;
            if (this.fParent.getMessageManager().getSpecialMarkerValue(specialMarkerNumber) == 1) {
                return Global.LOGO_DISPLAY_COLOR_LED_ON;
            }
            return Global.LOGO_DISPLAY_COLOR;
        }

        private class GotoMessageBlockButtonHandler
        implements ActionListener {
            private GotoMessageBlockButtonHandler() {
            }

            public void actionPerformed(ActionEvent ae) {
                MessageDisplay currentMessageDisplay = SingleMessagePanel.this.getMessageDisplay(null);
                if (currentMessageDisplay != null) {
                    Block block = SingleMessagePanel.this.getMessageDisplay(null).getMessageParameter().getBlock();
                    SingleMessagePanel.this.fGotoBlockAction.setBlock(block);
                    SingleMessagePanel.this.fGotoBlockAction.prepareAction();
                    SingleMessagePanel.this.fGotoBlockAction.doIt();
                }
            }
        }

        private class RightClickHandler
        extends MouseAdapter {
            private RightClickHandler() {
            }

            public void mousePressed(MouseEvent e) {
                LogoDisplay logoDisplay;
                DisplayElement displayElement;
                super.mousePressed(e);
                if (SwingUtilities.isRightMouseButton(e) && (displayElement = (logoDisplay = (LogoDisplay)e.getSource()).getModel().getElementAt(logoDisplay.getFocusPosition())) instanceof ParameterItem) {
                    ParameterItem parameterItem = (ParameterItem)displayElement;
                    Block block = parameterItem.getParameter().getBlock();
                    SingleMessagePanel.this.fBlockNumberLabel.setText(block.getLocalizedName(true));
                    SingleMessagePanel.this.fGotoBlockAction.setBlock(block);
                    SingleMessagePanel.this.fEditBlockPropertiesAction.setBlock(block);
                    if (MessageWindow.this.fIsOnlineTest) {
                        SingleMessagePanel.this.fEditBlockPropertiesAction.setEnabled(false);
                    } else {
                        SingleMessagePanel.this.fEditBlockPropertiesAction.setEnabled(true);
                    }
                    SingleMessagePanel.this.fPopupMenu.show(logoDisplay, e.getX(), e.getY());
                }
            }
        }

        private class MessageWindowGotoBlockAction
        extends GotoBlockAction {
            private MessageWindowGotoBlockAction() {
            }

            public boolean prepareAction() {
                return true;
            }

            public void setBlock(Block block) {
                this.fBlock = block;
            }
        }

        private class MessageWindowEditBlockPropertiesAction
        extends EditBlockPropertiesAction {
            private MessageWindowEditBlockPropertiesAction() {
            }

            public boolean prepareAction() {
                return true;
            }

            public void setBlock(Block block) {
                this.fBlock = block;
            }
        }
    }
}

